--
-- MoneyMoney Export Extension
-- http://moneymoney-app.com/api/export
--
-- Copyright (c) 2012-2013 Stefan Fürst. All rights reserved.
--
--
--


Exporter{version          = 1.03,
         format           = "GrandTotal",
         fileExtension    = "grandtotal",
         bundleIdentifier = "com.mediaatelier.GrandTotal3",
         reverseOrder     = true,
         description      = string.format(MM.localizeText("Export transactions for %s"), "GrandTotal")}



local function escapeStr (str)
if string.len(str) == 0 then
str = MM.localizeText("(Unknown)")
end
str = string.gsub(str, '[<>&]', {['<']='&lt;', ['>']='&gt;', ['&']='&amp;'})
return str
end


function WriteHeader (account, startDate, endDate, transactionCount)

assert(io.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>","\r\n"))
assert(io.write("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">","\r\n"))
assert(io.write("<plist version=\"1.0\">","\r\n"))
assert(io.write("        <dict>","\r\n"))
assert(io.write("                <key>source</key>","\r\n"))
assert(io.write("                <string>MoneyMoney - ",escapeStr(account.name),"</string>","\r\n"))
assert(io.write("                <key>type</key>","\r\n"))
assert(io.write("                <string>payments</string>","\r\n"))
assert(io.write("                <key>items</key>","\r\n"))
assert(io.write("                <array>","\r\n"))
end


function WriteTransactions (account, transactions)
local fitid = 0

-- Write transactions.
for _,transaction in ipairs(transactions) do

local trntype
local format = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'"

if transaction.amount > 0 then

local uidString =

assert(io.write("                        <dict>","\r\n"))
assert(io.write("                                <key>type</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.type),"</string>","\r\n"))
assert(io.write("                                <key>name</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.name),"</string>","\r\n"))
assert(io.write("                                <key>amount</key>","\r\n"))
assert(io.write("                                <real>",transaction.amount,"</real>","\r\n"))
assert(io.write("                                <key>currency</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.currency),"</string>","\r\n"))
assert(io.write("                                <key>purpose</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.purpose),"</string>","\r\n"))
assert(io.write("                                <key>bookingText</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.bookingText),"</string>","\r\n"))
assert(io.write("                                <key>bankCode</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.bankCode),"</string>","\r\n"))
assert(io.write("                                <key>bookingKey</key>","\r\n"))
assert(io.write("                                <string>",escapeStr(transaction.bookingKey),"</string>","\r\n"))
assert(io.write("                                <key>bookingDate</key>","\r\n"))
assert(io.write("                                <date>",MM.localizeDate(format,transaction.bookingDate),"</date>","\r\n"))
assert(io.write("                                <key>valueDate</key>","\r\n"))
assert(io.write("                                <date>",MM.localizeDate(format,transaction.valueDate),"</date>","\r\n"))
assert(io.write("                        </dict>","\r\n"))
end
end
end


function WriteTail (account)
assert(io.write("                </array>","\r\n"))
assert(io.write("        </dict>","\r\n"))
assert(io.write("</plist>"))
end

-- SIGNATURE: MCwCFFPlalIFZJdA0pHOTNjiKQVKJVH3AhRHS7DTdivRGgvrKcJxBWrH4s5hXw==
